// kicks players that dont move for a given time
// by norill

const int checkIntervalSeconds = 3 * 60;
const int kickWarnSeconds = 50;
Vec2f[] playersPos;
KickInfo@[] kickTimers;

class KickInfo
{
	string username;
	CPlayer@ player() {return getPlayerByUsername(username);}
	uint time;
	Vec2f pos;

	KickInfo() {}
};

void onTick(CRules@ this)
{
	if (getGameTime() % getTicksASecond() == 0)
	{
		for (uint i = 0; i < kickTimers.length; i++)
		{
			//check for erroneous entries
			if(!okToKickPlayer(kickTimers[i].player()))
			{
				kickTimers.removeAt(i--);
				continue;
			}

			if (kickTimers[i].time + getTicksASecond() * kickWarnSeconds <= getGameTime())
			{
				if (kickTimers[i].player() is getLocalPlayer())
				{
					client_AddToChat("You were kicked for being AFK too long.", SColor(255, 240, 50, 0));
					getNet().DisconnectClient(); //politely disconnect if we can
				}

				if (getNet().isServer())
				{
					KickPlayer(kickTimers[i].player());
				}

				kickTimers.removeAt(i--);
			}
			else
			{
				CBlob@ blob = kickTimers[i].player().getBlob();
				if (blob is null || blob.getPosition() != kickTimers[i].pos)
				{
					if (kickTimers[i].player() is getLocalPlayer() && !getNet().isServer())
					{
						client_AddToChat("AFK Kick avoided.", SColor(255, 20, 120, 0));
					}

					kickTimers.removeAt(i--);
				}
			}
		}
	}

	if (getGameTime() % (getTicksASecond() * checkIntervalSeconds) != 0) return;

	int count = getPlayerCount();
	playersPos.resize(count);
	for (uint i = 0; i < count; i++)
	{
		CPlayer@ p = getPlayer(i);
		CBlob@ blob = p.getBlob();
		if (blob !is null && okToKickPlayer(p))
		{
			if (playersPos[i] == blob.getPosition())
			{
				warnAFK(p);
			}
			playersPos[i] = blob.getPosition();
		}
		else
		{
			playersPos[i] = Vec2f(0, 0);
		}
	}
}

void warnAFK(CPlayer@ player)
{
	if (okToKickPlayer(player) && player is getLocalPlayer())
	{
		client_AddToChat("Seems like you are currently away from your keyboard.", SColor(255, 255, 100, 32));
		client_AddToChat("Move around or you will be kicked in "+kickWarnSeconds+" seconds!", SColor(255, 255, 100, 32));
	}

	KickInfo info;
	info.username = player.getUsername();
	info.time = getGameTime();
	info.pos = player.getBlob().getPosition();
	kickTimers.push_back(info);
}

bool okToKickPlayer(CPlayer@ player)
{
	return !(player.isBot() || player is getLocalPlayer() && getNet().isServer());
}
